/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _INDEX_HH
#define _INDEX_HH

#include <list>
#include "tag.hh"

typedef std::list<Tag> ListTags;

class IndexTags {
protected:
	ListFields constants;
	ListTags tags;
public:
	struct {
		bool ignore_standards_fields;
		bool recurse;
	} options;

	void tags_import_dir(std::string const path, bool const verbose = false);
	void tags_print();
	void constants_find();
	void constants_print();
	unsigned int count();	

	virtual void export_head();
	virtual void export_bottom();
	virtual void export_tag(Tag *tag);
	void export_all();

	virtual ~IndexTags();
};

class IndexTagsIni : public IndexTags {
public:
	void export_head();
	void export_bottom();
	void export_tag(Tag *tag);
};
#endif

