from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


apps = _Mock()

bind_kernel = _Mock()

check_for_zmq = _Mock()

client = _Mock()

cluster = _Mock()

collect_exceptions = _Mock()

controller = _Mock()

engine = _Mock()

error = _Mock()

factory = _Mock()

interactive = _Mock()

logger = _Mock()

os = _Mock()

parallel = _Mock()

print_function = _Mock()

remote = _Mock()

require = _Mock()

sys = _Mock()

traceback = _Mock()

unwrap_exception = _Mock()

util = _Mock()

warnings = _Mock()

wrap_exception = _Mock()

zmq = _Mock()

min_pyzmq = '2.1.11'

class AsyncHubResult(_Mock):
  pass
  _single_result = False

class AsyncMapResult(_Mock):
  pass
  _single_result = False

class AsyncResult(_Mock):
  pass
  _single_result = False

class Client(_Mock):
  pass
  _closed = False

class CompositeError(_Mock):
  pass
  tb_limit = 4

class Dependency(_Mock):
  pass
  all = True
  failure = True
  success = True

class DependencyTimeout(_Mock):
  pass


class DirectView(_Mock):
  pass
  skip_doctest = True

class EngineError(_Mock):
  pass


class IPythonError(_Mock):
  pass


class ImpossibleDependency(_Mock):
  pass


class InvalidDependency(_Mock):
  pass


class KernelError(_Mock):
  pass


class LoadBalancedView(_Mock):
  pass
  skip_doctest = True

class MultipleInstanceError(_Mock):
  pass


class NoEnginesRegistered(_Mock):
  pass


class ParallelFunction(_Mock):
  pass
  _mapping = False

class Reference(_Mock):
  pass


class RemoteError(_Mock):
  pass


class RemoteFunction(_Mock):
  pass


class TaskAborted(_Mock):
  pass


class TaskRejectError(_Mock):
  pass


class TaskTimeout(_Mock):
  pass


class TimeoutError(_Mock):
  pass


class UnmetDependency(_Mock):
  pass


class depend(_Mock):
  pass


class dependent(_Mock):
  pass


class unicode_type(_Mock):
  pass


