#!/usr/bin/perl
#
#  File:	pot2i18n.pl - Convert plugin pot file into i18n.c-format
#  Author:	Dieter Hametner
#  Version:	0.1
#
#  based on po2i18n.pl version 0.1 from Udo Richter
#
#  See the po2i18n/README file for copyright information and how to
#  reach the original author. Also general use is described there.
#
#  This version uses the CPAN module Locale::PO to read the .pot and .po files
#  which ensures, that these files are read correctly.
#
#  The usage of pot2i18n.pl differs from po2i18n.pl that it requires as first
#  argument the path to the plugins .pot file. There it then looks also for
#  the translated .po files which are used to create the result.
#  This version does not sort the msgids lexicaly (in contrast to po2i18n.pl)

use strict;
use warnings;

use Locale::PO;
use File::Basename;

my @LANGS = (
  "en_US",
  "de_DE",
  "sl_SI",
  "it_IT",
  "nl_NL",
  "pt_PT",
  "fr_FR",
  "nn_NO",
  "fi_FI",
  "pl_PL",
  "es_ES",
  "el_GR",
  "sv_SE",
  "ro_RO",
  "hu_HU",
  "ca_ES",
  "ru_RU",
  "hr_HR",
  "et_EE",
  "da_DK",
  "cs_CZ",
  "tr_TR"
  );

my %VERS = (
  "en_US" => 10200,
  "de_DE" => 10200,
  "sl_SI" => 10200,
  "it_IT" => 10200,
  "nl_NL" => 10200,
  "pt_PT" => 10200,
  "fr_FR" => 10200,
  "nn_NO" => 10200,
  "fi_FI" => 10200,
  "pl_PL" => 10200,
  "es_ES" => 10200,
  "el_GR" => 10200,
  "sv_SE" => 10200,
  "ro_RO" => 10200,
  "hu_HU" => 10200,
  "ca_ES" => 10200,
  "ru_RU" => 10302,
  "hr_HR" => 10307,
  "et_EE" => 10313,
  "da_DK" => 10316,
  "cs_CZ" => 10342,
  "tr_TR" => 10502
  );

die "Missing .pot file argument" unless $#ARGV >= 0;

my $potfile = $ARGV[0];
my $podir = dirname($potfile);

my $potRef = Locale::PO->load_file_asarray($potfile);
shift;

my %translations;

foreach my $lang (@LANGS) {
    $translations{$lang} = Locale::PO->load_file_ashash("$podir/$lang.po");
}

# debugging code: (may be removed)
#for my $po (@{$potRef}) {
#    my $msgid = $po->msgid;
#
#    print "UNTRANSLATED: ", $msgid, "\n";
#    next if $msgid eq "\"\"";
#    foreach my $lang (@LANGS) {
#	my $lhref = $translations{$lang};
#	my $lpo = ${$lhref}{$msgid};
#	$lpo = $po if !defined $lpo;
#
#	my $msg = $lpo->msgstr;
#	$msg = $lpo->msgid if !defined $msg;
#	$msg = $msgid if ($lang eq "en_US");
#	print $lang, ": ", $msg, "\n";
#    }
#    print "\n";
#}
#
#exit;

my $silent = 0;

while (<>) {
    my $line = $_;

    if ($line =~ /^\/\/ START I18N/) {
        print "// START I18N - automatically generated by pot2i18n.pl\n";
	foreach my $po (@{$potRef}) {
	    my $msgid = $po->msgid;
            next if $msgid eq "\"\"";

            my $head = "  { ";
            my $endif = "";
            my $versnum = 10200;

            for my $lang (@LANGS) {
                if ($VERS{$lang} ne $versnum) {
                    $versnum = $VERS{$lang};
                    print $endif;
                    print "#if VDRVERSNUM >= $versnum\n";
                    $endif = "#endif\n";
                }

		my $lhref = $translations{$lang};
		my $lpo = ${$lhref}{$msgid};
		$lpo = $po if !defined $lpo;

		my $msgstr = $lpo->msgstr;
		$msgstr = $lpo->msgid if !defined $msgstr;
		$msgstr = $msgid if ($lang eq "en_US");

                print "$head$msgstr,\n";
                $head = "    ";
            }
            print $endif;
            print "  },\n";
        }
        $silent = 1;
    }

    if (!$silent) { print $line; }

    if ($line =~ /^\/\/ END I18N/) {
        print "// END I18N - automatically generated by pot2i18n.pl\n";
        $silent = 0;
    }
}
