---
layout: transform
title: Partition Transform
permalink: /docs/transforms/partition/index.html
---

The **partition** transform computes the layout for an adjacency diagram: a space-filling variant of a node-link tree diagram. Rather than drawing a link between parent and child in the hierarchy, nodes are drawn as solid areas (either arcs or rectangles), and their placement relative to other nodes reveals their position in the hierarchy. The size of the nodes encodes a quantitative dimension that might be difficult to convey in a node-link diagram.

Internally, this transform processes a collection of special tree node objects generated by an upstream [nest](../nest) or [stratify](../stratify) transform. The original input data object can be accessed under the `data` field of these tree node objects. This transform uses the [d3-hierarchy library](https://github.com/d3/d3-hierarchy).

## Example

{% include embed spec="partition" %}

## Transform Parameters

| Property            | Type                           | Description   |
| :------------------ | :----------------------------: | :------------ |
| field               | {% include type t="Field" %}   | The data field corresponding to a numeric value for the node. The sum of values for a node and all its descendants is available on the node object as the `value` property. This field determines the size of a node. If unspecified, the layout will instead tally the counts of leaf nodes.|
| sort                | {% include type t="Compare" %} | A comparator for sorting sibling nodes. The inputs to the comparator are tree node objects, not input data objects.|
| padding             | {% include type t="Number" %}  | The padding to include between adjacent nodes (default `0`).|
| round               | {% include type t="Boolean" %} | Indicates if node layout values should be rounded (default `false`).|
| size                | {% include type t="Number[]" %}| The size of the layout, provided as a [width, height] array.|
| as                  | {% include type t="String[]" %}| The output fields at which to write the layout results. The default is `["x0", "y0", "x1", "y1", "depth", "children"]`, where `x0`, `y0`, `x1` and `y1` are the starting and ending layout coordinates for each segment, `depth` is the tree depth, and `children` is the count of a node's children in the tree.|

## Usage

```json
{
  "type": "partition",
  "field": "value",
  "padding": 1,
  "size": [{"signal": "width"}, {"signal": "height"}]
}
```

Computes a partition layout with `1` pixel padding between nodes, using the full width and height of the view. Leaf nodes are sized proportionally to the `value` field.
