<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

require_once( 'database.inc.php' );

function wi_check_config()
{
    global $config, $body;

    if ( !wi_check_database() ) {
        $body .= "<p><strong>ERROR:</strong> No database engine selected or engine is not available.</p>\n";
        return false;
    }

    if ( !wi_open_database() ) {
        $body .= "<p><strong>ERROR:</strong> Could not connect to the database server.</p>\n";
        return false;
    }

    if ( $config[ 'storage_path' ] != '' ) {
        $storage_path = wi_make_absolute_path( $config[ 'storage_path' ] );
        if ( !is_dir( $storage_path ) ) {
            $body .= "<p><strong>ERROR:</strong> The storage path does not exist or is not accessible.</p>\n";
            return false;
        }
        $path = $storage_path . '/' . uniqid( mt_rand() ) . '.tmp';
        $fh = @fopen( $path, 'a' );
        if ( !$fh ) {
            $body .= "<p><strong>ERROR:</strong> The storage path is not writable.</p>\n";
            return false;
        }
        fclose( $fh );
        unlink( $path );
    }

    foreach ( array( 'errors', 'commands', 'sql', 'cron' ) as $name ) {
        if ( isset( $config[ "log_$name" ] ) && $config[ "log_$name" ] != '' ) {
            if ( !wi_log_check( $name ) ) {
                $body .= "<p><strong>ERROR:</strong> The log path does not exist or is not writable.</p>\n";
                return false;
            }
        }
    }

    return true;
}

function wi_read_queries( $group = null )
{
    $lines = wi_read_sql_file();
    if ( !empty( $group ) )
        $lines = wi_filter_sql_group( $lines, $group );
    return wi_split_sql_queries( $lines );
}

function wi_read_sql_file()
{
    global $config;

    $engine = $config[ 'db_engine' ];

    if ( $engine == 'mysql' ) {
        if ( version_compare( mysql_get_server_info(), '4.1', '>=' ) )
            $file = 'mysql41';
        else
            $file = 'mysql40';
    } else if ( $engine == 'mysqli' ) {
        $file = 'mysql41';
    } else {
        $file = $engine;
    }

    return file( wi_make_absolute_path( "setup/schema-$file.sql" ) );
}

function wi_filter_sql_group( $lines, $group )
{
    $filtered = array();
    $current_group = '';

    foreach ( $lines as $line ) {
        if ( substr( $line, 0, 4 ) == '-- [' )
            $current_group = substr( $line, 4, strpos( $line, ']' ) - 4 );
        else if ( $current_group == $group )
            $filtered[] = $line;
    }

    return $filtered;
}

function wi_split_sql_queries( $lines )
{
    $queries = array();
    $query = '';

    foreach ( $lines as $line ) {
        if ( substr( $line, 0, 4 ) == '----' ) {
            $queries[] = trim( $query );
            $query = '';
        } else if ( substr( $line, 0, 2 ) != '--' ) {
            $query .= $line;
        }
    }

    return $queries;
}
