// Copyright (c) Facebook, Inc. and its affiliates.
// All rights reserved.
//
// Copyright 2019 Google LLC
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.
//
// Auto-generated file. Do not edit!
//   Specification: test/f32-dwconv-unipass-minmax.yaml
//   Generator: tools/generate-dwconv-unipass-test.py


#include <gtest/gtest.h>

#include <xnnpack/common.h>
#include <xnnpack/isa-checks.h>

#include <xnnpack/dwconv.h>
#include "dwconv-microkernel-tester.h"


#if XNN_ARCH_ARM64 && XNN_ENABLE_ASSEMBLY
  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM64 && XNN_ENABLE_ASSEMBLY


#if XNN_ARCH_ARM64 && XNN_ENABLE_ASSEMBLY
  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 12; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 12; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 12; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 12; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 12; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 12; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 12; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__ASM_AARCH64_NEONFMA_CORTEX_A55, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 12; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__asm_aarch64_neonfma_cortex_a55, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM64 && XNN_ENABLE_ASSEMBLY


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P4C__NEON, c_eq_4) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, c_div_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, c_lt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, c_gt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, c_eq_4) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, c_div_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, c_lt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, c_gt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P8C__NEON, c_eq_8) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, c_div_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, c_lt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, c_gt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, c_eq_8) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, c_div_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, c_lt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, c_gt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, c_div_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, c_div_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P16C__NEON, c_eq_16) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, c_div_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, c_lt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, c_gt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, c_eq_16) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, c_div_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, c_lt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, c_gt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, c_eq_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, c_div_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, c_lt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, c_gt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, c_eq_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, c_div_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, c_lt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, c_gt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P4C__NEON, c_eq_4) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, c_div_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, c_lt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, c_gt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, c_eq_4) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, c_div_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, c_lt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, c_gt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P8C__NEON, c_eq_8) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, c_div_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, c_lt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, c_gt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, c_eq_8) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, c_div_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, c_lt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, c_gt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, c_div_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, c_div_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P16C__NEON, c_eq_16) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, c_div_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, c_lt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, c_gt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, c_eq_16) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, c_div_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, c_lt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, c_gt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, c_eq_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, c_div_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, c_lt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, c_gt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, c_eq_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, c_div_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, c_lt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, c_gt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P4C__NEON, c_eq_4) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, c_div_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, c_lt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, c_gt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, c_eq_4) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, c_div_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, c_lt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, c_gt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P8C__NEON, c_eq_8) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, c_div_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, c_lt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, c_gt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, c_eq_8) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, c_div_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, c_lt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, c_gt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, c_div_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, c_div_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P16C__NEON, c_eq_16) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, c_div_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, c_lt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, c_gt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, c_eq_16) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, c_div_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, c_lt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, c_gt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, c_eq_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, c_div_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, c_lt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, c_gt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, c_eq_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, c_div_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, c_lt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, c_gt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P4C__NEON, c_eq_4) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, c_div_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, c_lt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, c_gt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, c_eq_4) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, c_div_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, c_lt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, c_gt_4) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, c_eq_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, c_div_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, c_lt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, c_gt_4) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P8C__NEON, c_eq_8) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, c_div_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, c_lt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, c_gt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, c_eq_8) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, c_div_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, c_lt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, c_gt_8) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, c_div_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, c_eq_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, c_div_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, c_lt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, c_gt_8) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P16C__NEON, c_eq_16) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, c_div_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, c_lt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, c_gt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, c_eq_16) {
    TEST_REQUIRES_ARM_NEON;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, c_div_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, c_lt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, c_gt_16) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEON_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neon_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, c_eq_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, c_div_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, c_lt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, c_gt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_ARM || XNN_ARCH_ARM64
  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, c_eq_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, c_div_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, c_lt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, c_gt_16) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, multipixel) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, multipixel_with_step) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, input_offset) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__NEONFMA_ACC2, zero) {
    TEST_REQUIRES_ARM_NEON_FMA;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__neonfma_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P4C__SSE, c_eq_4) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, c_div_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, c_div_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, c_div_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, c_lt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, c_gt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, c_gt_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, c_gt_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, c_eq_4) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, c_div_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, c_lt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, c_gt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__SSE_ACC2, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P8C__SSE, c_eq_8) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, c_div_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, c_lt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, c_gt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, c_div_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__SSE_ACC2, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P4C__SSE, c_eq_4) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, c_div_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, c_div_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, c_div_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, c_lt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, c_gt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, c_gt_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, c_gt_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, c_eq_4) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, c_div_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, c_lt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, c_gt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__SSE_ACC2, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P8C__SSE, c_eq_8) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, c_div_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, c_lt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, c_gt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, c_div_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__SSE_ACC2, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P4C__SSE, c_eq_4) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, c_div_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, c_div_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, c_div_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, c_lt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, c_gt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, c_gt_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, c_gt_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, c_eq_4) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, c_div_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, c_lt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, c_gt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__SSE_ACC2, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P8C__SSE, c_eq_8) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, c_div_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, c_lt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, c_gt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, c_div_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__SSE_ACC2, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P4C__SSE, c_eq_4) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, c_div_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, c_div_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, c_div_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, c_lt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, c_gt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, c_gt_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, c_gt_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, c_eq_4) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, c_div_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, c_div_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, c_div_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, c_lt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, c_gt_4) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, c_gt_4_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, c_gt_4_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__SSE_ACC2, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P8C__SSE, c_eq_8) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, c_div_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, c_lt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, c_gt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_SSE;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, c_div_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, multipixel) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_SSE;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, input_offset) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__SSE_ACC2, zero) {
    TEST_REQUIRES_X86_SSE;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__sse_acc2, xnn_init_f32_minmax_sse_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P8C__AVX, c_eq_8) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, c_div_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, c_lt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, c_gt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, c_div_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__AVX_ACC2, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P16C__AVX, c_eq_16) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, c_div_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, c_lt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, c_gt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, c_div_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX_ACC2, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P8C__AVX, c_eq_8) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, c_div_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, c_lt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, c_gt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, c_div_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__AVX_ACC2, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P16C__AVX, c_eq_16) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, c_div_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, c_lt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, c_gt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, c_div_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX_ACC2, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P8C__AVX, c_eq_8) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, c_div_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, c_lt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, c_gt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, c_div_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__AVX_ACC2, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P16C__AVX, c_eq_16) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, c_div_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, c_lt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, c_gt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, c_div_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX_ACC2, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P8C__AVX, c_eq_8) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, c_div_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, c_lt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, c_gt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, c_div_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__AVX_ACC2, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P16C__AVX, c_eq_16) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, c_div_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, c_lt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, c_gt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_AVX;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, c_div_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX_ACC2, zero) {
    TEST_REQUIRES_X86_AVX;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, c_eq_8) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, c_div_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, c_lt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, c_gt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, c_div_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__FMA3_ACC2, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, c_eq_16) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, c_div_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, c_lt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, c_gt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, c_div_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__FMA3_ACC2, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, c_eq_8) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, c_div_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, c_lt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, c_gt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, c_div_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__FMA3_ACC2, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, c_eq_16) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, c_div_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, c_lt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, c_gt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, c_div_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__FMA3_ACC2, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, c_eq_8) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, c_div_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, c_lt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, c_gt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, c_div_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__FMA3_ACC2, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, c_eq_16) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, c_div_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, c_lt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, c_gt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, c_div_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__FMA3_ACC2, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, c_eq_8) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, c_div_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, c_lt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, c_gt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, c_eq_8) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, c_div_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, c_div_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, c_div_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, c_lt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, c_gt_8) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, c_gt_8_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, c_gt_8_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__FMA3_ACC2, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, c_eq_16) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, c_div_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, c_lt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, c_gt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_FMA3;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, c_div_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, multipixel) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_FMA3;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, input_offset) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__FMA3_ACC2, zero) {
    TEST_REQUIRES_X86_FMA3;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__fma3_acc2, xnn_init_f32_minmax_avx_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, c_eq_16) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, c_div_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, c_lt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, c_gt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(3)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, c_div_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P16C__AVX512F_ACC2, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, c_eq_32) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(32)
      .kernel_tile(3)
      .channels(32)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, c_div_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, c_div_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, c_div_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, c_lt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, c_gt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, c_gt_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, c_gt_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(163)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(592)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 64; channels < 512; channels += 96) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(592)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, c_eq_32) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(32)
      .kernel_tile(3)
      .channels(32)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, c_div_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, c_div_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, c_div_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, c_lt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, c_gt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, c_gt_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, c_gt_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(163)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(592)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P32C__AVX512F_ACC2, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 64; channels < 512; channels += 96) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(592)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, c_eq_16) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, c_div_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, c_lt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, c_gt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(4)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, c_div_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P16C__AVX512F_ACC2, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, c_eq_32) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(32)
      .kernel_tile(4)
      .channels(32)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, c_div_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, c_div_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, c_div_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, c_lt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, c_gt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, c_gt_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, c_gt_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(163)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(592)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 64; channels < 512; channels += 96) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(592)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, c_eq_32) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(32)
      .kernel_tile(4)
      .channels(32)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, c_div_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, c_div_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, c_div_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, c_lt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, c_gt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, c_gt_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, c_gt_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(163)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(592)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P32C__AVX512F_ACC2, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 64; channels < 512; channels += 96) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(592)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, c_eq_16) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, c_div_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, c_lt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, c_gt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(9)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, c_div_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P16C__AVX512F_ACC2, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, c_eq_32) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(32)
      .kernel_tile(9)
      .channels(32)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, c_div_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, c_div_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, c_div_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, c_lt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, c_gt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, c_gt_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, c_gt_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(163)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(592)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 64; channels < 512; channels += 96) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(592)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, c_eq_32) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(32)
      .kernel_tile(9)
      .channels(32)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, c_div_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, c_div_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, c_div_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, c_lt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, c_gt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, c_gt_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, c_gt_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(163)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(592)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P32C__AVX512F_ACC2, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 64; channels < 512; channels += 96) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(592)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, c_eq_16) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, c_div_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, c_lt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, c_gt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, c_eq_16) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(16)
      .kernel_tile(25)
      .channels(16)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, c_div_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, c_div_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, c_div_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, c_lt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, c_gt_16) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, c_gt_16_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, c_gt_16_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 17; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(83)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 80; channels += 15) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 32; channels < 256; channels += 48) {
      DWConvMicrokernelTester()
        .channel_tile(16)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(304)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P16C__AVX512F_ACC2, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 32; channels < 256; channels += 48) {
        DWConvMicrokernelTester()
          .channel_tile(16)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(304)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p16c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, c_eq_32) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(32)
      .kernel_tile(25)
      .channels(32)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, c_div_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, c_div_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, c_div_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, c_lt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, c_gt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, c_gt_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, c_gt_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(163)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(592)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 64; channels < 512; channels += 96) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(592)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_X86 || XNN_ARCH_X86_64
  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, c_eq_32) {
    TEST_REQUIRES_X86_AVX512F;
    DWConvMicrokernelTester()
      .channel_tile(32)
      .kernel_tile(25)
      .channels(32)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, c_div_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, c_div_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, c_div_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, c_lt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 1; channels < 32; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, c_gt_32) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, c_gt_32_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, c_gt_32_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 33; channels < 64; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, multipixel) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, multipixel_with_step) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, multipixel_with_output_stride) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(163)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, multipixel_with_qmin) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, multipixel_with_qmax) {
    TEST_REQUIRES_X86_AVX512F;
    for (size_t channels = 1; channels <= 160; channels += 31) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, input_offset) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t channels = 64; channels < 512; channels += 96) {
      DWConvMicrokernelTester()
        .channel_tile(32)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(592)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P32C__AVX512F_ACC2, zero) {
    TEST_REQUIRES_X86_AVX512F;
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 64; channels < 512; channels += 96) {
        DWConvMicrokernelTester()
          .channel_tile(32)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(592)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p32c__avx512f_acc2, xnn_init_f32_minmax_scalar_params);
      }
    }
  }
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_ARM_ACC2, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMSIMD_X86_ACC2, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_ARM_ACC2, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMSIMD_X86_ACC2, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_ARM_ACC2, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMSIMD_X86_ACC2, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_ARM_ACC2, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMSIMD_X86_ACC2, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_ARM_ACC2, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMSIMD_X86_ACC2, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_ARM_ACC2, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMSIMD_X86_ACC2, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM, zero) {
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_ARM_ACC2, zero) {
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86, zero) {
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(25)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P4C__WASMSIMD_X86_ACC2, zero) {
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p4c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM, zero) {
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_ARM_ACC2, zero) {
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_arm_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86, zero) {
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(25)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 25; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(25)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_25P8C__WASMSIMD_X86_ACC2, zero) {
    for (uint32_t mz = 0; mz < 25; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(25)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_25p8c__wasmsimd_x86_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_ACC2, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(3)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P4C__WASMRELAXEDSIMD_FMA_ACC2, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_ACC2, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(3)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 3; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(3)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_3P8C__WASMRELAXEDSIMD_FMA_ACC2, zero) {
    for (uint32_t mz = 0; mz < 3; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(3)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_3p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_ACC2, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(4)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P4C__WASMRELAXEDSIMD_FMA_ACC2, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_ACC2, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(4)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 4; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(4)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_4P8C__WASMRELAXEDSIMD_FMA_ACC2, zero) {
    for (uint32_t mz = 0; mz < 4; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(4)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_4p8c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_ACC2, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, c_eq_4) {
    DWConvMicrokernelTester()
      .channel_tile(4)
      .kernel_tile(9)
      .channels(4)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4_with_qmin) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, c_div_4_with_qmax) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, c_lt_4) {
    for (uint32_t channels = 1; channels < 4; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4_with_qmin) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, c_gt_4_with_qmax) {
    for (uint32_t channels = 5; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(23)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 20; channels += 3) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, input_offset) {
    for (uint32_t channels = 8; channels < 64; channels += 12) {
      DWConvMicrokernelTester()
        .channel_tile(4)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(112)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P4C__WASMRELAXEDSIMD_FMA_ACC2, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 8; channels < 64; channels += 12) {
        DWConvMicrokernelTester()
          .channel_tile(4)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(112)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p4c__wasmrelaxedsimd_fma_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, multipixel) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_step) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      for (size_t step = 2; step <= 9; step++) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .width(3)
          .step(step)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_output_stride) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(5)
        .output_stride(43)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmin) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, multipixel_with_qmax) {
    for (size_t channels = 1; channels <= 40; channels += 7) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .width(3)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, input_offset) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .input_offset(176)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_ACC2, zero) {
    for (uint32_t mz = 0; mz < 9; mz++) {
      for (uint32_t channels = 16; channels < 128; channels += 24) {
        DWConvMicrokernelTester()
          .channel_tile(8)
          .kernel_tile(9)
          .channels(channels)
          .input_offset(176)
          .zero_index(mz)
          .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_acc2, xnn_init_f32_minmax_wasmsimd_params);
      }
    }
  }
#endif  // XNN_ARCH_WASMRELAXEDSIMD


#if XNN_ARCH_WASMRELAXEDSIMD
  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_FMA, c_eq_8) {
    DWConvMicrokernelTester()
      .channel_tile(8)
      .kernel_tile(9)
      .channels(8)
      .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_FMA, c_div_8) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_FMA, c_div_8_with_qmin) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_FMA, c_div_8_with_qmax) {
    for (uint32_t channels = 16; channels < 128; channels += 24) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_FMA, c_lt_8) {
    for (uint32_t channels = 1; channels < 8; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_FMA, c_gt_8) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_FMA, c_gt_8_with_qmin) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmin(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
    }
  }

  TEST(F32_DWCONV_MINMAX_9P8C__WASMRELAXEDSIMD_FMA, c_gt_8_with_qmax) {
    for (uint32_t channels = 9; channels < 16; channels++) {
      DWConvMicrokernelTester()
        .channel_tile(8)
        .kernel_tile(9)
        .channels(channels)
        .qmax(128)
        .Test(xnn_f32_dwconv_minmax_ukernel_9p8c__wasmrelaxedsimd_fma, xnn_init_f32_minmax_wasmsimd_params);
 